/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedCornerPillarBlock
extends FramedBlock {
    public FramedCornerPillarBlock() {
        super(BlockType.FRAMED_CORNER_PILLAR);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction face = context.m_43719_();
        Vec3 hitPoint = Utils.fraction(context.m_43720_());
        if (face.m_122434_().m_122479_()) {
            state = FramedCornerPillarBlock.withCornerFacing(state, context.m_43719_(), context.m_8125_(), context.m_43720_());
        } else {
            double z;
            Direction dir;
            double x = hitPoint.m_7096_();
            if (x > 0.5 != Utils.isPositive(dir = (z = hitPoint.m_7094_()) > 0.5 ? Direction.SOUTH : Direction.NORTH)) {
                dir = dir.m_122427_();
            }
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        }
        return FramedCornerPillarBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = rot.m_55954_((Direction)state.m_61143_((Property)FramedProperties.FACING_HOR));
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedCornerPillarBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }
}

